import type { FC } from 'react';
import styled from 'styled-components';
import { TextType, Title, TitleSize } from 'twitch-core-ui';
import type { FocusableCoreButtonProps } from '../../FocusableCoreButton';
import { FocusableCoreButton } from '../../FocusableCoreButton';

const ScFocusableCoreButton = styled(FocusableCoreButton)`
  border-radius: 0.5rem !important;
  height: 6rem;
  padding: 1rem;
`;

type FocusableMenuButtonProps = Omit<FocusableCoreButtonProps, 'fullWidth'> & {
  text: string;
};

// istanbul ignore next: trivial
export const FocusableMenuButton: FC<FocusableMenuButtonProps> = ({
  focusIndex,
  text,
  ...props
}) => (
  <ScFocusableCoreButton
    contentLeft
    focusIndex={focusIndex}
    fullWidth
    withUnfocusBackground
    {...props}
  >
    <Title size={TitleSize.Small} type={TextType.H2}>
      {text}
    </Title>
  </ScFocusableCoreButton>
);

FocusableMenuButton.displayName = 'FocusableMenuButton';
