import type { FC } from 'react';
import styled from 'styled-components';
import { refFocusHandler, useFocus } from 'tachyon-tv-nav';
import type { CoreInteractiveProps } from 'twitch-core-ui';
import { Background, CoreInteractive, ThemeRegion } from 'twitch-core-ui';
import { focusableBorderStyle } from '../../styleMixins';
import type { MenuOptionProps } from '../MenuOption';
import { MENU_OPTION_HEIGHT_REM, MenuOption } from '../MenuOption';

export type FocusableSettingsMenuOptionProps = MenuOptionProps & {
  focusIndex: number;
  interactive: Omit<CoreInteractiveProps, 'refHandler'>;
};

const ScCoreInteractive = styled(CoreInteractive)<{ $focused: boolean }>`
  display: block;
  ${focusableBorderStyle}
  width: 100%;
`;

export const FOCUSABLE_SETTINGS_MENU_OPTION_HEIGHT_REM = MENU_OPTION_HEIGHT_REM;

// istanbul ignore next: trivial
export const FocusableSettingsMenuOption: FC<FocusableSettingsMenuOptionProps> =
  ({ focusIndex, interactive, ...menuProps }) => {
    const { focused, takeFocus } = useFocus(focusIndex);

    return (
      <ThemeRegion
        background={Background.Inherit}
        fullWidth
        theme={focused ? 'light' : 'dark'}
      >
        <ScCoreInteractive
          $focused={focused}
          onMouseEnter={takeFocus}
          refHandler={refFocusHandler(focused)}
          {...interactive}
        >
          <MenuOption {...menuProps} />
        </ScCoreInteractive>
      </ThemeRegion>
    );
  };

FocusableSettingsMenuOption.displayName = 'FocusableSettingsMenuOption';
