import type { FC, ReactNode } from 'react';
import styled from 'styled-components';
import { CoreText, Layout, TextType, Title, TitleSize } from 'twitch-core-ui';

type SettingsPromptProps = {
  subHeading?: string;
  svg?: ReactNode;
  title: string;
};

// istanbul ignore next: trivial
const ScContainer = styled.div`
  align-items: center;
  display: flex;
  height: 100%;
  justify-content: center;
  margin: auto;
  padding-top: 10rem;
  width: 75vw;
`;

// istanbul ignore next: trivial
const ScSvgContainer = styled.div`
  display: flex;
  height: 100%;
  justify-content: flex-start;
  padding-right: 10rem;
  width: 50%;
`;

// istanbul ignore next: trivial
const ScPromptContainer = styled.div`
  display: flex;
  flex-direction: column;
  justify-content: center;
`;

// istanbul ignore next: trivial
/**
 * Provides a common layout for creating a settings menu pages consisting of a title, optional
 * sub-heading, and one or two user actions.
 *
 * Use SettingsMenu instead for settings menu pages that are best represented as a list of options
 * rather than yes / no confirmations or other types of single action prompts.
 */
export const SettingsPrompt: FC<SettingsPromptProps> = ({
  children,
  subHeading,
  svg,
  title,
}) => {
  return (
    <ScContainer>
      {svg && <ScSvgContainer>{svg}</ScSvgContainer>}
      <ScPromptContainer>
        <Title size={TitleSize.Large} type={TextType.H1}>
          {title}
        </Title>
        {subHeading && (
          <Layout margin={{ top: 1 }}>
            <CoreText type={TextType.H5}>{subHeading}</CoreText>
          </Layout>
        )}
        <Layout padding={{ top: 2 }}>{children}</Layout>
      </ScPromptContainer>
    </ScContainer>
  );
};

SettingsPrompt.displayName = 'SettingsPrompt';
