import styled from 'styled-components';
import { fadeIn } from '../styleMixins';

// istanbul ignore next: trivial
/**
 * This component creates a full-viewport-width container that is vertically
 * constrained to ensure a 16:9 aspect ratio, allowing children to use either
 * rem- or percentage-based heights and avoid using `vh`, which is vital to
 * ensuring that the app scales appropriately for any TV resolution. Beyond
 * creating this root 16:9 box, it does not handle any page layout concerns.
 *
 * Maintaining position: relative with a z-index of 1 grants us flexibility
 * to use negative z-index values on page content without running the risk of
 * content stacking behind the background. This is an issue isolated to 2017
 * LG TVs (Chrome 38) as of now so it's easy to regress on.
 */
export const StarshotMain = styled.main`
  height: calc(100vw * 9 / 16);
  ${fadeIn}
  overflow: hidden;
  position: relative;
  width: 100vw;
  z-index: 1;
`;
