import type { FC } from 'react';
import styled from 'styled-components';
import { useNotificationConsumer } from 'tachyon-notification';
import {
  InFeatureNotification,
  Layout,
  NotificationType,
  Position,
  Snackbar,
  SnackbarMessage,
  ZIndex,
} from 'twitch-core-ui';
import { OVERSCAN_PADDING_REM, TOP_NAV_HEIGHT_REM } from '../../../config';
import type {
  StarshotNotification,
  StarshotNotificationMeta,
} from '../../../hooks';

const ScToast = styled(Layout)`
  padding: ${OVERSCAN_PADDING_REM}rem;
  padding-top: ${TOP_NAV_HEIGHT_REM}rem;
  pointer-events: none;
`;

const bannerType: Record<StarshotNotification['type'], NotificationType> = {
  error: NotificationType.Error,
  info: NotificationType.Info,
  success: NotificationType.Success,
  warning: NotificationType.Warning,
};

// istanbul ignore next: low value
export const Toaster: FC = () => {
  const notifications = useNotificationConsumer<StarshotNotificationMeta>({
    limit: 1,
    order: 'fifo',
  });

  return (
    <ScToast
      attachRight
      attachTop
      position={Position.Absolute}
      zIndex={ZIndex.Above}
    >
      <Layout margin={{ bottom: 2 }} width="41.66vw">
        {notifications.map((notification) => {
          const type = bannerType[notification.type];
          switch (notification.meta.displayType) {
            case 'snack-bar': {
              return (
                <Snackbar
                  key={notification.id}
                  message={
                    <SnackbarMessage
                      iconType={type}
                      title={notification.meta.message}
                    />
                  }
                  type={type}
                />
              );
            }
            case 'in-feature-notification': {
              return (
                <InFeatureNotification
                  key={notification.id}
                  message={notification.meta.message}
                  type={type}
                />
              );
            }
          }
        })}
      </Layout>
    </ScToast>
  );
};

Toaster.displayName = 'Toaster';
