import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { NodeNav } from 'tachyon-tv-nav';
import { Layout, SVGAsset } from 'twitch-core-ui';
import {
  RouteName,
  renderTachyonLink,
  routeNameFromPathname,
} from '../../../routing';
import { FocusableIconButton } from '../FocusableIconButton';

const SIDE_PAD_AMOUNT_REM = 1;

type NavIconProps = {
  focusIndex: number;
};

// istanbul ignore next: trivial
export const NavIcons: FC<NavIconProps> = ({ focusIndex }) => {
  const { formatMessage } = useIntl();
  const { currentPathname } = useRouterUtils();
  const currentRouteName = routeNameFromPathname(currentPathname);
  return (
    <NodeNav focusIndex={focusIndex}>
      <Layout padding={{ left: SIDE_PAD_AMOUNT_REM }}>
        <FocusableIconButton
          aria-label={formatMessage('Settings', 'TopNav')}
          focusIndex={0}
          icon={SVGAsset.NavSettings}
          linkTo="/deferToRenderLink"
          renderLink={renderTachyonLink({
            route: RouteName.Settings,
          })}
          withUnfocusBackground={currentRouteName === RouteName.Settings}
        />
      </Layout>
    </NodeNav>
  );
};

NavIcons.displayName = 'NavIcons';
