import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { HorizontalNav } from 'tachyon-tv-nav';
import {
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
} from 'twitch-core-ui';
import {
  RouteName,
  renderTachyonLink,
  routeNameFromPathname,
} from '../../../../routing';
import { FocusableTextButton } from '../../FocusableTextButton';

const SIDE_PAD_AMOUNT_REM = 1;

type NavMenuProps = {
  focusIndex: number;
  loggedIn: boolean;
};

const NavMenuButtonText: FC = ({ children }) => (
  <CoreText bold fontSize={FontSize.Size5}>
    {children}
  </CoreText>
);
NavMenuButtonText.displayName = 'MenuText';

export const NavMenu: FC<NavMenuProps> = ({ focusIndex, loggedIn }) => {
  const { formatMessage } = useIntl();
  const { currentPathname } = useRouterUtils();
  const currentRouteName = routeNameFromPathname(currentPathname);
  const loggedInIdx = loggedIn ? 0 : 1;

  return (
    <HorizontalNav elementCount={loggedIn ? 3 : 4} focusIndex={focusIndex}>
      <Layout display={Display.Flex} flexDirection={FlexDirection.Row}>
        {!loggedIn && (
          <Layout padding={{ x: SIDE_PAD_AMOUNT_REM }}>
            <FocusableTextButton
              focusIndex={0}
              linkTo="/deferToRenderLink"
              renderLink={renderTachyonLink({
                route: RouteName.Login,
              })}
              withUnfocusBackground={currentRouteName === RouteName.Login}
            >
              <NavMenuButtonText>
                {formatMessage('Sign In', 'TopNav')}
              </NavMenuButtonText>
            </FocusableTextButton>
          </Layout>
        )}
        <Layout padding={{ x: SIDE_PAD_AMOUNT_REM }}>
          <FocusableTextButton
            focusIndex={0 + loggedInIdx}
            linkTo="/deferToRenderLink"
            renderLink={renderTachyonLink({
              route: RouteName.Homepage,
            })}
            withUnfocusBackground={currentRouteName === RouteName.Homepage}
          >
            <NavMenuButtonText>
              {formatMessage('Home', 'TopNav')}
            </NavMenuButtonText>
          </FocusableTextButton>
        </Layout>
        <Layout padding={{ x: SIDE_PAD_AMOUNT_REM }}>
          <FocusableTextButton
            focusIndex={1 + loggedInIdx}
            linkTo="/deferToRenderLink"
            renderLink={renderTachyonLink({
              route: RouteName.GamesDirectory,
            })}
            withUnfocusBackground={
              currentRouteName === RouteName.GamesDirectory
            }
          >
            <NavMenuButtonText>
              {formatMessage('Browse', 'TopNav')}
            </NavMenuButtonText>
          </FocusableTextButton>
        </Layout>
        <Layout padding={{ x: SIDE_PAD_AMOUNT_REM }}>
          <FocusableTextButton
            focusIndex={2 + loggedInIdx}
            linkTo="/deferToRenderLink"
            renderLink={renderTachyonLink({
              route: RouteName.Search,
            })}
            withUnfocusBackground={currentRouteName === RouteName.Search}
          >
            <NavMenuButtonText>
              {formatMessage('Search', 'TopNav')}
            </NavMenuButtonText>
          </FocusableTextButton>
        </Layout>
      </Layout>
    </HorizontalNav>
  );
};

NavMenu.displayName = 'NavMenu';
