import { createMountWrapperFactory } from 'tachyon-test-utils';
import { NavMenu } from '.';

describe(NavMenu, () => {
  const setup = createMountWrapperFactory(NavMenu, () => ({
    focusIndex: 0,
    loggedIn: true,
  }));

  it("shows 'Browse', 'Home', 'Search', and 'Sign In' buttons when logged out", () => {
    const { wrapper } = setup({ loggedIn: false });

    expect(wrapper).toIncludeText('Sign In');
    expect(wrapper).toIncludeText('Home');
    expect(wrapper).toIncludeText('Browse');
    expect(wrapper).toIncludeText('Search');
  });

  it("shows 'Home', 'Browse', and 'Search' buttons when logged in", () => {
    const { wrapper } = setup({ loggedIn: true });

    expect(wrapper).not.toIncludeText('Sign In');
    expect(wrapper).toIncludeText('Home');
    expect(wrapper).toIncludeText('Browse');
    expect(wrapper).toIncludeText('Search');
  });
});
