import { createMountWrapperFactory } from 'tachyon-test-utils';
import { BackButton } from '../BackButton';
import { Glitch } from './Glitch';
import { NavIcons } from './NavIcons';
import { NavMenu } from './NavMenu';
import { TopNav } from '.';

let mockUseCurrentUser = { loggedIn: true };
jest.mock('tachyon-auth', () => ({
  ...jest.requireActual('tachyon-auth'),
  useCurrentUser: () => mockUseCurrentUser,
}));

describe(TopNav, () => {
  const setupWithBackButton = createMountWrapperFactory(TopNav, () => ({
    displayBackButton: true,
    focusIndex: 0,
  }));

  const setupWithNavMenu = createMountWrapperFactory(TopNav, () => ({
    displayNavMenu: true,
    focusIndex: 0,
  }));

  it('shows the back button when displayBackButton is true', () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setupWithBackButton();

    expect(wrapper.find(BackButton)).toExist();
    expect(wrapper.find(Glitch)).not.toExist();
  });

  it('shows the glitch when displayBackButton is undefined', () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setupWithNavMenu();

    expect(wrapper.find(Glitch)).toExist();
    expect(wrapper.find(BackButton)).not.toExist();
  });

  it('renders the NavMenu and NavIcons components when displayNavMenu is true', () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setupWithNavMenu();

    expect(wrapper.find(NavMenu)).toExist();
    expect(wrapper.find(NavIcons)).toExist();
  });

  it('does not render the NavMenu or NavIcons components when displayNavMenu is undefined', () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setupWithBackButton();

    expect(wrapper.find(NavMenu)).not.toExist();
    expect(wrapper.find(NavIcons)).not.toExist();
  });
});
