import styled from 'styled-components';
import type { LayoutProps } from 'twitch-core-ui';
import { Display, Layout } from 'twitch-core-ui';

// istanbul ignore next: trivial
/**
 * This layout should be used when we want a flex container that has
 * children that the layout needs to shrink. By default, a flex container
 * can't be smaller than it's children (min-width: auto), but this is
 * problematic especially in the case where we want to text-overflow
 * ellipsis.
 *
 * https://dfmcphee.com/flex-items-and-min-width-0/
 */
export const TruncatedTextFlexContainer = styled(
  (props: Omit<LayoutProps, 'display'>) => (
    <Layout display={Display.Flex} {...props} />
  ),
)`
  min-width: 0;
`;
