import type { VerticalNavProps } from 'tachyon-tv-nav';
import { VerticalNav } from 'tachyon-tv-nav';
import { CARD_ANIMATION_TIMING_S } from '../../../config';
import { BufferShelfDarkOverlay } from '../BufferShelfDarkOverlay';
import { SHELF_FRAME_HEIGHT_REM } from '../HorizontalShelf';
import type { MovableListProps } from '../MovableList';
import { MovableList } from '../MovableList';

export interface VerticalShelfListProps<T>
  extends Pick<MovableListProps<T>, 'items'>,
    Pick<VerticalNavProps, 'takeFocusOnFirstRender'> {
  focusIndex: number;
  shelfRenderer: (item: T, idx: number) => JSX.Element;
}

export function VerticalShelfList<T>({
  focusIndex,
  items,
  shelfRenderer,
  takeFocusOnFirstRender,
}: VerticalShelfListProps<T>): JSX.Element {
  return (
    <>
      <VerticalNav
        elementCount={items.length}
        focusIndex={focusIndex}
        handleWheel
        takeFocusOnFirstRender={takeFocusOnFirstRender}
      >
        <MovableList
          direction="vertical"
          elementsPerLine={1}
          itemRenderer={shelfRenderer}
          items={items}
          leadingBufferLines={1}
          lineSizeRem={SHELF_FRAME_HEIGHT_REM}
          trailingBufferLines={1}
          transitionDurationS={CARD_ANIMATION_TIMING_S}
          visibleLines={1}
        />
      </VerticalNav>
      <BufferShelfDarkOverlay
        heightRem={SHELF_FRAME_HEIGHT_REM}
        verticalOffsetRem={SHELF_FRAME_HEIGHT_REM}
      />
    </>
  );
}

VerticalShelfList.displayName = 'VerticalShelfList';
