import type { VerticalShelfListProps } from '.';

/**
 * Mock for integration testing provided item / rendered behavior. Use via:
 *
 * jest.mock('../../common/VerticalShelfList', () => {
 *   const { MockVerticalShelfList } = jest.requireActual(
 *     '../../common/VerticalShelfList/test-mocks',
 *   );
 *   return { VerticalShelfList: MockVerticalShelfList };
 * });
 */
export function MockVerticalShelfList<T>({
  items,
  shelfRenderer,
}: VerticalShelfListProps<T>): JSX.Element {
  return <div>{items.map(shelfRenderer)}</div>;
}

MockVerticalShelfList.displayName = 'MockVerticalShelfList';
