import type { FC } from 'react';
import { Layout, Position, ZIndex } from 'twitch-core-ui';

// istanbul ignore next: trivial
/**
 * A component that contains a mix of content that needs to remain at a higher
 * elevation relative to the lower content which is free to scroll under
 * the elevated content.
 *
 * See also:
 * `VerticalShelvesPage.ElevatedContent`
 * `VerticalShelvesPage.ScrollUnderContent`
 */
export const VerticalShelvesPage: FC & {
  ElevatedContent: FC;
  ScrollUnderContent: FC;
} = ({ children }) => (
  <Layout children={children} fullWidth position={Position.Fixed} />
);
VerticalShelvesPage.displayName = 'VerticalShelvesPage';

// istanbul ignore next: trivial
/**
 * This component is intended to be provided as a child component to a
 * `VerticalShelvesPage` and holds content that should have a higher z-index,
 * elevating it above other content which is free to scroll below it.
 */
VerticalShelvesPage.ElevatedContent = ({ children }) => (
  <Layout children={children} position={Position.Relative} />
);
VerticalShelvesPage.ElevatedContent.displayName =
  'VerticalShelvesPage.ElevatedContent';

// istanbul ignore next: trivial
/**
 * This component is intended to be provided as a child component to a
 * `VerticalShelvesPage` and holds content that should have a lower z-index,
 * allowing it to scroll under the elevated content on the page which is
 * usually displayed in a fixed position.
 */
VerticalShelvesPage.ScrollUnderContent = ({ children }) => (
  <Layout
    children={children}
    position={Position.Relative}
    zIndex={ZIndex.Below}
  />
);
VerticalShelvesPage.ScrollUnderContent.displayName =
  'VerticalShelvesPage.ScrollUnderContent';
