import { createMountWrapperFactory } from 'tachyon-test-utils';
import { ProgressBar } from 'twitch-core-ui';
import { ProgressBarOverlay, clamp } from '.';

describe(ProgressBarOverlay, () => {
  const setup = createMountWrapperFactory(ProgressBarOverlay, () => ({
    duration: 0,
    position: 0,
  }));

  it('returns null when duration is null', () => {
    const { wrapper } = setup({
      duration: null,
      position: 1234,
    });

    expect(wrapper).toBeEmptyRender();
  });

  it('returns null when position is null', () => {
    const { wrapper } = setup({ duration: 1234, position: null });

    expect(wrapper).toBeEmptyRender();
  });

  it('returns null when duration is zero', () => {
    const { wrapper } = setup({ duration: 0, position: 1234 });

    expect(wrapper).toBeEmptyRender();
  });

  it('returns null when position is zero', () => {
    const { wrapper } = setup({ duration: 1234, position: 0 });

    expect(wrapper).toBeEmptyRender();
  });

  it('renders a progress bar with the correct percent value', () => {
    const { wrapper } = setup({ duration: 1000, position: 500 });

    expect(wrapper.find(ProgressBar)).toExist();
    expect(wrapper.find(ProgressBar).prop('value')).toEqual(50);
  });
});

describe(clamp, () => {
  it.each`
    val    | lower | upper   | expected
    ${0}   | ${10} | ${1000} | ${10}
    ${30}  | ${10} | ${25}   | ${25}
    ${500} | ${0}  | ${1000} | ${500}
    ${0}   | ${0}  | ${100}  | ${0}
  `(
    'returns $expected when val is $val lower bound is $lower and upper bound is $upper',
    ({ expected, lower, upper, val }) => {
      expect(clamp(val, lower, upper)).toBe(expected);
    },
  );
});
