import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { formatLiveViewersCount } from 'tachyon-more-ui';
import { SVGAsset, Stat } from 'twitch-core-ui';
import { PlaybackOverlayItem } from '../PlaybackOverlayItem';

type ViewerCountProps = { isLive: boolean; viewersCount: number };

// istanbul ignore next: trivial
export const ViewerCount: FC<ViewerCountProps> = ({ isLive, viewersCount }) => {
  const { formatMessage, formatNumber } = useIntl();
  const formattedViewersCount = formatNumber(viewersCount);

  return (
    <PlaybackOverlayItem>
      <Stat
        icon={isLive ? SVGAsset.Friends : SVGAsset.GlyphViews}
        label={formatLiveViewersCount(
          formatMessage,
          viewersCount,
          formattedViewersCount,
        )}
        value={formattedViewersCount}
      />
    </PlaybackOverlayItem>
  );
};

ViewerCount.displayName = 'ViewerCount';
