import type { CSSObject } from 'styled-components';
import { DarkThemeMap, StaticTokenMap } from 'twitch-core-ui-tokens';

export type FocusableStyleProps = { $focused: boolean };

// This ads in a focusable border to a UI component.  The border is implemented
// as a border-shadow and does not effect the size of the UI component.
export function focusableBorderStyle({
  $focused,
}: FocusableStyleProps): CSSObject {
  const rules: CSSObject = {
    border: '0.25rem solid',
    borderRadius: `${StaticTokenMap['border-radius-large']}`,
  };

  if ($focused) {
    rules.borderColor = `${DarkThemeMap['color-background-body']}`;
    rules.boxShadow = `0 0 0 0.25rem ${DarkThemeMap['color-border-button-active']}`;
  } else {
    rules.borderColor = 'transparent';
  }

  return rules;
}
