import type { FC } from 'react';
import {
  AlignItems,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  Position,
} from 'twitch-core-ui';
import { StarshotMain } from '../common';

type ErrorBaseProps = {
  img: JSX.Element;
};

// istanbul ignore next: trivial
export const ErrorBase: FC<ErrorBaseProps> = ({ children, img }) => (
  <StarshotMain>
    <Layout
      alignItems={AlignItems.Center}
      attachBottom
      attachLeft
      attachRight
      attachTop
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      justifyContent={JustifyContent.Center}
      position={Position.Absolute}
    >
      {children}
    </Layout>
    {img}
  </StarshotMain>
);

ErrorBase.displayName = 'ErrorBase';
