import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { HorizontalNav } from 'tachyon-tv-nav';
import { CoreText, Layout, Position, TextType } from 'twitch-core-ui';
import type { FocusableTextButtonProps } from '../common';
import { FocusableTextButton } from '../common';
import { ErrorBase } from './ErrorBase';

export type InternalServerErrorProps = {
  secondaryAction?: Omit<FocusableTextButtonProps, 'focusIndex'>;
};

// istanbul ignore next: trivial
export const InternalServerError: FC<InternalServerErrorProps> = ({
  secondaryAction,
}) => {
  const { formatMessage } = useIntl();

  return (
    <ErrorBase
      img={
        <Layout attachBottom attachLeft position={Position.Absolute}>
          <img alt="" src="/static/starshot/images/error-500.png" />
        </Layout>
      }
    >
      <CoreText type={TextType.H3}>
        {formatMessage(
          'Looks like something went wrong, please try again later.',
          'InternalServerError',
        )}
      </CoreText>
      <Layout margin={{ top: 3 }}>
        <HorizontalNav
          elementCount={secondaryAction ? 2 : 1}
          focusIndex={0}
          takeFocusOnFirstRender
        >
          <FocusableTextButton
            focusIndex={0}
            onClick={() => {
              // We do a full window reload (causes a SSR'd page request for the current path)
              // as a form of cache-busting in the event that we've hot fixed a bug.
              // Otherwise, the user has no means of refreshing  and would be stuck on a buggy version until
              // the next full app boot.
              window.location.reload();
            }}
          >
            {formatMessage('Retry', 'Retry')}
          </FocusableTextButton>
          {secondaryAction && (
            <FocusableTextButton {...secondaryAction} focusIndex={1} />
          )}
        </HorizontalNav>
      </Layout>
    </ErrorBase>
  );
};

InternalServerError.displayName = 'InternalServerError';
