import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { CoreText, Layout, Position, TextType } from 'twitch-core-ui';
import {
  RouteName,
  renderTachyonLink,
  useTachyonRouter,
} from '../../../routing';
import type { FocusableTextButtonProps } from '../../common';
import { FocusableTextButton } from '../../common';
import { ErrorBase } from '../ErrorBase';

export const NotFoundError: FC = () => {
  const { formatMessage } = useIntl();
  const router = useTachyonRouter();
  const { pageCount } = useRouterUtils();

  // if this is the first page in a session, render a link to the home page
  // otherwise, show a back button to return to previous page
  const buttonProps: Omit<FocusableTextButtonProps, 'focusIndex'> =
    pageCount === 1
      ? {
          children: formatMessage('Home', 'NotFoundError'),
          linkTo: '/deferToRenderLink',
          renderLink: renderTachyonLink({
            route: RouteName.Homepage,
          }),
        }
      : {
          children: formatMessage('Back', 'NotFoundError'),
          onClick: () => {
            router.back();
          },
        };

  return (
    <ErrorBase
      img={
        <Layout attachBottom attachRight position={Position.Absolute}>
          <img alt="" src="/static/starshot/images/error-404.png" />
        </Layout>
      }
    >
      <CoreText type={TextType.H3}>
        {formatMessage('Sorry, that page is in another castle!', 'NotFound')}
      </CoreText>
      <Layout margin={{ top: 3 }}>
        <FocusableTextButton focusIndex={0} {...buttonProps} />
      </Layout>
    </ErrorBase>
  );
};

NotFoundError.displayName = 'NotFoundError';
