import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { mockRouter } from '../../../routing/test-mocks';
import { FocusableTextButton } from '../../common';
import { NotFoundError } from '.';

let mockPageCount = 0;
jest.mock('tachyon-next-routing-utils', () => ({
  useRouterUtils: () => ({ pageCount: mockPageCount }),
}));

jest.mock('../../../routing', () => ({
  RouteName: {},
  renderTachyonLink: () => null,
  useTachyonRouter: () => mockRouter,
}));

jest.mock('../../common', () => ({
  FocusableTextButton: (props: any) => <>{props.children}</>,
}));

jest.mock('../ErrorBase', () => ({
  ErrorBase: (props: any) => <>{props.children}</>,
}));

describe(NotFoundError, () => {
  beforeEach(() => {
    mockPageCount = 0;
  });

  const setup = createShallowWrapperFactory(NotFoundError);

  it('renders home link if page is first in session', () => {
    mockPageCount = 1;
    const { wrapper } = setup();

    expect(wrapper.find(FocusableTextButton).contains('Home')).toBeTruthy();
  });

  it('renders back link if page is not first in session', () => {
    mockPageCount = 2;
    const { wrapper } = setup();

    expect(wrapper.find(FocusableTextButton).contains('Back')).toBeTruthy();
  });
});
