import { Platform, useStaticEnvironment } from 'tachyon-environment';
import { SwitchSoundEffects } from './platforms';

export type BrowserSoundEffects = {
  back?: () => void;
};

const defaultSoundEffects: BrowserSoundEffects = {};

// An interface to access platform specific browser sound effects.
// Currently only used by the Nintendo Switch to play their back sfx
// when navigating back using the gamepad.
// istanbul ignore next: trivial
export function useBrowserSoundEffects(): BrowserSoundEffects {
  const {
    common: { platform },
  } = useStaticEnvironment();

  if (platform === Platform.Switch) {
    return SwitchSoundEffects;
  }

  return defaultSoundEffects;
}
