import type { BrowserSoundEffects } from '../..';

type SwitchSound =
  | 'SeBtnDecide'
  | 'SeFooterDecideBack'
  | 'SeTextAreaMove'
  | 'SeWebButtonDecide'
  | 'SeWebChangeCursorPointer'
  | 'SeWebCheckboxCheck'
  | 'SeWebCheckboxUncheck'
  | 'SeWebKeyError'
  | 'SeWebLinkDecide'
  | 'SeWebMenuListOpen'
  | 'SeWebNaviFocus'
  | 'SeWebPointerFocus'
  | 'SeWebRadioBtnOn'
  | 'SeWebTextboxStartEdit'
  | 'SeWebTouchFocus'
  | 'SeWebZoomIn'
  | 'SeWebZoomOut';

type SwitchNx = {
  playSystemSe: (label: SwitchSound) => void;
};

// Declaration of Nintendo's browser APIs
declare global {
  interface Window {
    nx: SwitchNx | undefined;
  }
}

// istanbul ignore next: trivial
export const SwitchSoundEffects: BrowserSoundEffects = {
  back: () => {
    if (window.nx) {
      window.nx.playSystemSe('SeFooterDecideBack');
    }
  },
};
