import type { FC } from 'react';
import { createContext, useContext, useMemo, useState } from 'react';

type ChatAllowedContext = {
  isChatAllowed: boolean;
  setIsChatAllowed: (chatAllowed: boolean) => void;
};

// istanbul ignore next: trivial
const chatAllowedContext = createContext<ChatAllowedContext>({
  isChatAllowed: true,
  setIsChatAllowed: () => null,
});

// istanbul ignore next: trivial
export const useChatAllowed = (): ChatAllowedContext => {
  return useContext(chatAllowedContext);
};

type ChatAllowedRootProps = {
  defaultChatAllowed?: boolean;
};

export const ChatAllowedRoot: FC<ChatAllowedRootProps> = ({
  children,
  defaultChatAllowed = true,
}) => {
  const [isChatAllowed, setIsChatAllowed] =
    useState<boolean>(defaultChatAllowed);

  const ctx = useMemo(
    () => ({
      isChatAllowed,
      setIsChatAllowed: (newChatAllowedValue: boolean) => {
        setIsChatAllowed(newChatAllowedValue);
      },
    }),
    [isChatAllowed],
  );

  return <chatAllowedContext.Provider children={children} value={ctx} />;
};

ChatAllowedRoot.displayName = 'ChatAllowedRoot';
