import { act } from 'react-dom/test-utils';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChatAllowedRoot } from '.';

describe(ChatAllowedRoot, () => {
  const setup = createShallowWrapperFactory(ChatAllowedRoot);
  it('isChatAllowed will be truthy when no props are passed', () => {
    const { wrapper } = setup();

    expect((wrapper.props() as any).value.isChatAllowed).toBeTruthy();
  });

  it('isChatAllowed will be false when false is the default state', () => {
    const { wrapper } = setup({ defaultChatAllowed: false });

    expect((wrapper.props() as any).value.isChatAllowed).toBeFalsy();
  });

  it('sets isChatAllowed when setIsChatAllowed is called', () => {
    const { wrapper } = setup({ defaultChatAllowed: false });

    expect((wrapper.props() as any).value.isChatAllowed).toBeFalsy();

    act(() => {
      (wrapper.props() as any).value.setIsChatAllowed(true);
    });

    expect((wrapper.props() as any).value.isChatAllowed).toBeTruthy();
  });
});
