import type { FC } from 'react';
import { createContext, useContext, useMemo } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import { isBrowser } from 'tachyon-utils';
import type { NativeProxy } from '../proxies';
import { createNativeAppProxy, createStubNativeAppProxy } from '../proxies';

const nativeAppProxyContext = createContext<NativeProxy>(
  createStubNativeAppProxy(),
);

/**
 * Root object to provide access to a native proxy interface that is platform-specific.
 * This must exist somewhere under a StarshotEnvironmentRoot.
 */
export const NativeAppProxyRoot: FC = ({ children }) => {
  const {
    common: { platform },
  } = useStaticEnvironment();

  const ctx = useMemo<NativeProxy>(
    () => createNativeAppProxy(isBrowser(), platform),
    [platform],
  );

  return <nativeAppProxyContext.Provider children={children} value={ctx} />;
};

NativeAppProxyRoot.displayName = 'NativeAppProxyRoot';

/**
 * Obtains a NativeAppProxyContext instance, assuming NativeAppProxyRoot is
 * an ancestor in the DOM.
 */
export const useNativeAppProxy = (): NativeProxy => {
  return useContext(nativeAppProxyContext);
};
