import type { NativeBrowserWindowProxy, NativeProxy } from '../proxy';

// NOTE: On Android TV and Fire TV window.androidTvNativeHooks will be set by the native
// application code when running on the client.
declare global {
  interface Window {
    androidTvNativeHooks: NativeBrowserWindowProxy | undefined;
  }
}

/**
 * Creates an implementation of StarshotNativeAppProxyContext which wraps the native interface for Android/Fire TV.
 */
export function createAndroidNativeAppProxy(): NativeProxy {
  return {
    loggedIn: ({ access_token, refresh_token }) => {
      window.androidTvNativeHooks?.loggedIn(access_token, refresh_token);
    },
    loggedOut: () => {
      window.androidTvNativeHooks?.loggedOut();
    },
    nativeProxyType: 'android-hooks',
    setPlaybackPosition: (playerState: string, positionSeconds: number) => {
      window.androidTvNativeHooks?.setPlaybackPosition(
        playerState,
        positionSeconds,
      );
    },
    videoPlayerStateChanged: (state: string) => {
      window.androidTvNativeHooks?.videoPlayerStateChanged(state);
    },
  };
}
