import type { OAuthToken } from 'tachyon-auth';
import type { NativeBrowserWindowProxy } from '../proxy';
import { createAndroidNativeAppProxy } from '.';

declare global {
  interface Window {
    androidTvNativeHooks: NativeBrowserWindowProxy | undefined;
  }
}

function mockAndroidNativeHooks(func: () => any): NativeBrowserWindowProxy {
  const mocks: NativeBrowserWindowProxy = {
    loggedIn: jest.fn(() => undefined),
    loggedOut: jest.fn(() => undefined),
    nativeProxyType: 'stub',
    setPlaybackPosition: () => undefined,
    videoPlayerStateChanged: () => undefined,
  };

  const previousHooks = window.androidTvNativeHooks;
  window.androidTvNativeHooks = mocks;
  func();
  window.androidTvNativeHooks = previousHooks;

  return mocks;
}

const mockTokenResponse = {
  access_token: '1234',
  refresh_token: '5678',
} as OAuthToken;

describe('androidtv proxy', () => {
  it('verifies AndroidNativeAppProxy calls into expected native hooks', () => {
    const proxy = createAndroidNativeAppProxy();
    const nativeHooksMock = mockAndroidNativeHooks(() => {
      proxy.loggedIn?.(mockTokenResponse);
      proxy.loggedOut();
    });

    expect(nativeHooksMock.loggedIn).toHaveBeenCalledTimes(1);
    expect(nativeHooksMock.loggedIn).toHaveBeenCalledWith(
      mockTokenResponse.access_token,
      mockTokenResponse.refresh_token,
    );
    expect(nativeHooksMock.loggedOut).toHaveBeenCalledTimes(1);
  });
});
