import { Platform } from 'tachyon-environment';
import { createAndroidNativeAppProxy } from './androidtv';
import type { NativeProxy } from './proxy';
import { createStubNativeAppProxy } from './stub';
import { createSwitchNativeAppProxy } from './switch';

/**
 * Use environment state to determine the appropriate proxy type and instantiate it.
 */
export function createNativeAppProxy(
  browser: boolean,
  platform: Platform,
): NativeProxy {
  if (browser) {
    switch (platform) {
      case Platform.AndroidTV:
      case Platform.FireTV:
        return createAndroidNativeAppProxy();
      case Platform.Switch:
        return createSwitchNativeAppProxy();
    }
  }
  return createStubNativeAppProxy();
}
