import type { OAuthToken } from 'tachyon-auth';

export type NativeProxyType = 'android-hooks' | 'stub' | 'switch' | 'websocket';

/**
 * The common interface used between the application and platform specific
 * proxies.
 */
export interface NativeProxy {
  loggedIn?: (response: OAuthToken) => void;
  loggedOut: () => void;
  readonly nativeProxyType: NativeProxyType;
  setPlaybackPosition: (playerState: string, positionSeconds: number) => void;
  videoPlayerStateChanged: (state: string) => void;
}

/**
 * The interface of the object attached to browser window when the Native App Shell
 * supports that proxy mode.
 */
export interface NativeBrowserWindowProxy {
  loggedIn: (accessToken: string, refreshToken: string) => void;
  loggedOut: () => void;
  readonly nativeProxyType: NativeProxyType;
  setPlaybackPosition: (playerState: string, positionSeconds: number) => void;
  videoPlayerStateChanged: (state: string) => void;
}
