import type { NativeProxy } from './proxy';

/**
 * Creates a NOOP implementation of StarshotNativeAppProxyContext suitable for SSR and clients
 * which do not have a need for a native proxy.
 */
// istanbul ignore next: trivial
export function createStubNativeAppProxy(): NativeProxy {
  return {
    loggedIn: () => undefined,
    loggedOut: () => undefined,
    nativeProxyType: 'stub',
    setPlaybackPosition: () => undefined,
    videoPlayerStateChanged: () => undefined,
  };
}
