import { parseUrl } from 'query-string';
import { flattenHeaderOrParam } from 'tachyon-utils';
import {
  ACCESS_TOKEN_FRAGMENT_PARAM,
  REDIRECT_ROUTE_PARAM_KEY,
  REFRESH_TOKEN_FRAGMENT_PARAM,
} from '../../../../../config';
import { getAccessAndRefreshTokenFromUrlFragment } from '../../../../../utils';
import type { NativeProxy } from '../proxy';
import { createSwitchIpcUrl } from './utils';

/**
 * Creates an implementation of StarshotNativeAppProxyContext which wraps the native interface for Switch.
 */
// istanbul ignore next: trivial
export function createSwitchNativeAppProxy(): NativeProxy {
  const href = window.location.href;
  const auth = getAccessAndRefreshTokenFromUrlFragment(href);

  return {
    // if the accessToken is present then this was a request sent from native
    // and we should not initialize the loggedIn procedure.
    loggedIn: auth?.accessToken
      ? undefined
      : ({ access_token, refresh_token }) => {
          const { query } = parseUrl(window.location.href);
          const successRedirect =
            flattenHeaderOrParam(query[REDIRECT_ROUTE_PARAM_KEY]) ?? '';

          window.location.assign(
            createSwitchIpcUrl({
              [ACCESS_TOKEN_FRAGMENT_PARAM]: access_token,
              [REFRESH_TOKEN_FRAGMENT_PARAM]: refresh_token,
              callback: 'login',
              context: encodeURIComponent(successRedirect),
            }),
          );
        },
    loggedOut: () => {
      window.location.assign(createSwitchIpcUrl({ callback: 'logout' }));
    },
    nativeProxyType: 'switch',
    setPlaybackPosition: () => null,
    videoPlayerStateChanged: () => null,
  };
}
