/* eslint-disable @typescript-eslint/unbound-method */
import { random } from 'faker';
import type { OAuthToken } from 'tachyon-auth';
import {
  ACCESS_TOKEN_FRAGMENT_PARAM,
  REFRESH_TOKEN_FRAGMENT_PARAM,
} from '../../../../../config';
import { getAccessAndRefreshTokenFromUrlFragment } from '../../../../../utils';
import { createSwitchIpcUrl } from './utils';
import { createSwitchNativeAppProxy } from '.';

jest.mock('../../../../../utils', () => ({
  ...jest.requireActual('../../../../../utils'),
  getAccessAndRefreshTokenFromUrlFragment: jest.fn(() => ({})),
}));
jest.mock('./utils');

const mockGetAccessToken = getAccessAndRefreshTokenFromUrlFragment as jest.Mock;
const mockCreateRedirectUrl = createSwitchIpcUrl as jest.Mock;

describe('switch proxy', () => {
  // we have to fully clear jsdom's stub here
  delete (window as any).location;
  (window as any).location = {
    assign: jest.fn(),
    href: '/login?success-redirect-route=route%3Dchannel_home%26routeParams%3Dlogin%253Dmonstercat',
  };

  it('calls the IPC route with the logout callback when logout is called', () => {
    mockCreateRedirectUrl.mockReturnValueOnce('expected-return-value');
    const proxy = createSwitchNativeAppProxy();
    proxy.loggedOut();

    expect(window.location.assign).toHaveBeenCalledWith(
      'expected-return-value',
    );
    expect(mockCreateRedirectUrl).toHaveBeenCalledWith({ callback: 'logout' });
  });

  it('calls the IPC route with the login callback when login is called', () => {
    mockCreateRedirectUrl.mockReturnValueOnce('returned-url');
    mockGetAccessToken.mockReturnValueOnce({ accessToken: undefined });
    const proxy = createSwitchNativeAppProxy();
    const mockAccessToken = random.alpha();
    const mockRefreshToken = random.alpha();
    proxy.loggedIn?.({
      access_token: mockAccessToken,
      refresh_token: mockRefreshToken,
    } as OAuthToken);

    expect(mockCreateRedirectUrl).toHaveBeenCalledWith({
      [ACCESS_TOKEN_FRAGMENT_PARAM]: mockAccessToken,
      [REFRESH_TOKEN_FRAGMENT_PARAM]: mockRefreshToken,
      callback: 'login',
      context: 'route%3Dchannel_home%26routeParams%3Dlogin%253Dmonstercat',
    });
    expect(window.location.assign).toHaveBeenCalledWith('returned-url');
  });

  it('does not initialize login when there is auth data present', () => {
    mockCreateRedirectUrl.mockReturnValueOnce('returned-url');
    mockGetAccessToken.mockReturnValueOnce({ accessToken: 'some-auth-token' });
    const proxy = createSwitchNativeAppProxy();
    expect(proxy.loggedIn).toBeUndefined();
  });
});
