import type {
  ACCESS_TOKEN_FRAGMENT_PARAM,
  REFRESH_TOKEN_FRAGMENT_PARAM,
} from '../../../../../../config';

/**
 * These procedures are defined in native-apps/nintendo-switch/app/include/app/ipc.hpp
 */
type IpcContext = {
  context?: string;
};

type LoginProcedure = IpcContext & {
  [ACCESS_TOKEN_FRAGMENT_PARAM]: string;
  [REFRESH_TOKEN_FRAGMENT_PARAM]: string;
  callback: 'login';
};

type LogoutProcedure = IpcContext & {
  callback: 'logout';
};

export const IPC_URL_BASE = 'https://switch.tv.twitch.tv/_ipc';

export function createSwitchIpcUrl(
  args: LoginProcedure | LogoutProcedure,
): string {
  const redirectUrl = new URL(IPC_URL_BASE);
  for (const [key, value] of Object.entries(args)) {
    redirectUrl.searchParams.append(key, value);
  }

  return redirectUrl.toString();
}
