import { random } from 'faker';
import {
  ACCESS_TOKEN_FRAGMENT_PARAM,
  REFRESH_TOKEN_FRAGMENT_PARAM,
} from '../../../../../../config';
import { IPC_URL_BASE, createSwitchIpcUrl } from '.';

describe(createSwitchIpcUrl, () => {
  it('creates a url with IPC_URL_BASE as the base and the expected query params', () => {
    const mockAccessToken = random.alpha();
    const mockRefreshToken = random.alpha();
    const redirectUrl = createSwitchIpcUrl({
      [ACCESS_TOKEN_FRAGMENT_PARAM]: mockAccessToken,
      [REFRESH_TOKEN_FRAGMENT_PARAM]: mockRefreshToken,
    } as any);

    expect(redirectUrl).toEqual(
      `${IPC_URL_BASE}?${ACCESS_TOKEN_FRAGMENT_PARAM}=${mockAccessToken}&${REFRESH_TOKEN_FRAGMENT_PARAM}=${mockRefreshToken}`,
    );
  });
});
