import type { OAuthToken } from 'tachyon-auth';
import { Platform } from 'tachyon-environment';
import { createNativeAppProxy } from './factory';
import { createStubNativeAppProxy } from './stub';

describe('native proxies', () => {
  it.each([[Platform.AndroidTV], [Platform.FireTV], [Platform.Web]])(
    'uses StubNativeAppProxy when not in browser ($s)',
    (platform: Platform) => {
      const proxy = createNativeAppProxy(false, platform);
      expect(proxy.nativeProxyType).toBe('stub');
    },
  );

  it.each([
    [Platform.Web],
    [Platform.LG],
    [Platform.MobileWeb],
    [Platform.PS4],
    [Platform.Prospero],
    [Platform.Samsung],
    [Platform.StarshotDev],
    [Platform.StarshotStaging],
    [Platform.StarshotWeb],
    [Platform.Unknown],
    [Platform.Vestel],
  ])(
    'uses StubNativeAppProxy when in browser on a platform that does not have a proxy ($s)',
    (platform: Platform) => {
      const proxy = createNativeAppProxy(true, platform);
      expect(proxy.nativeProxyType).toBe('stub');
    },
  );

  it.each([[Platform.AndroidTV], [Platform.FireTV]])(
    'uses AndroidNativeAppProxy when on Android TV platforms ($s)',
    (platform: Platform) => {
      const proxy = createNativeAppProxy(true, platform);
      expect(proxy.nativeProxyType).toBe('android-hooks');
    },
  );

  it('uses SwitchNativeAppProxy when on the switch platform', () => {
    const proxy = createNativeAppProxy(true, Platform.Switch);
    expect(proxy.nativeProxyType).toBe('switch');
  });

  it('verifies StubNativeAppProxy is a no-op', () => {
    const proxy = createStubNativeAppProxy();

    expect(proxy.nativeProxyType).toBe('stub');

    expect(() => {
      proxy.loggedIn?.({
        access_token: '1234',
        refresh_token: '5678',
      } as OAuthToken);
      proxy.loggedOut();
    }).not.toThrow();
  });
});
