import type { FC } from 'react';
import styled from 'styled-components';
import { useStaticEnvironment } from 'tachyon-environment';
import { CoreText } from 'twitch-core-ui';

// istanbul ignore next: debug tools
const ScDebugInfoOverlayContainer = styled.div`
  background: black;
  left: 0;
  padding: 2rem;
  position: absolute;
  top: 0;
  width: 33%;
  z-index: 50;
`;

// istanbul ignore next: debug tools
export const DebugInfoOverlay: FC = () => {
  const env = useStaticEnvironment();

  return (
    <ScDebugInfoOverlayContainer>
      <CoreText>
        Debug Mode Activated, Go to settings or close the app to disable
      </CoreText>
      <CoreText>{process.env.BUILD_ID}</CoreText>
      <CoreText>{env.client.agentInfo.getUA()}</CoreText>
      <CoreText>Device ID: {env.client.deviceID}</CoreText>
      <CoreText>Session ID: {env.client.sessionID}</CoreText>
    </ScDebugInfoOverlayContainer>
  );
};

DebugInfoOverlay.displayName = 'Debug Info';
