import type { FC } from 'react';
import { createGlobalStyle } from 'styled-components';
import { Platform, useStaticEnvironment } from 'tachyon-environment';

const GlobalHoveredStyles = createGlobalStyle`
  div:hover {
    border: solid green 1px;
  }
  a:hover {
    border: solid red 10px;
  }
  *:hover {
    border: solid blue 5px;
  }
`;

// istanbul ignore next: debug tools
export const HoverOutlineDebugger: FC = () => {
  const {
    common: { appEnvironment, platform },
  } = useStaticEnvironment();

  if (platform === Platform.LG || appEnvironment !== 'production') {
    return <GlobalHoveredStyles />;
  }
  return null;
};

HoverOutlineDebugger.displayName = 'HoverOutlineDebugger';
