import type { FC } from 'react';
import { useEffect } from 'react';
import { legacyKeyboardEventHandler } from 'tachyon-utils';
import { useStarshotNotification } from '../../../../hooks';

// istanbul ignore next: non-production code
export const KeyDebugger: FC = () => {
  const { publish } = useStarshotNotification();

  useEffect(() => {
    const showKeyInfo = legacyKeyboardEventHandler((e: KeyboardEvent) => {
      publish({
        autoCloseMs: 1000,
        meta: {
          displayType: 'snack-bar',
          message: `Key/Code: ${e.key}/${e.keyCode} `,
        },
        type: 'info',
      });
    });

    document.addEventListener('keydown', showKeyInfo);
    return () => {
      document.removeEventListener('keydown', showKeyInfo);
    };
  }, [publish]);

  return null;
};
