import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../../../routing';
import { FocusableIconButton } from '../../../../../common';

type ChannelSettingsButtonProps = {
  focusIndex: number;
  login: string;
};

// istanbul ignore next: trivial
export const ChannelSettingsButton: FC<ChannelSettingsButtonProps> = ({
  focusIndex,
  login,
}) => {
  const { formatMessage } = useIntl();

  return (
    <FocusableIconButton
      aria-label={formatMessage('Channel Settings', 'BottomControls')}
      focusIndex={focusIndex}
      icon={SVGAsset.NavMore}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        route: RouteName.SettingsChannel,
        routeParams: { login },
      })}
    />
  );
};

ChannelSettingsButton.displayName = 'ChannelSettingsButton';
