import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { FocusableIconButton } from '../../../../../common';

export type ToggleChatButtonProps = {
  chatVisible: boolean;
  focusIndex: number;
  onClick: () => void;
};

export const ToggleChatButton: FC<ToggleChatButtonProps> = ({
  chatVisible,
  focusIndex,
  onClick,
}) => {
  const { formatMessage } = useIntl();
  const label = chatVisible
    ? formatMessage('Hide chat', 'ToggleChatButton')
    : formatMessage('Show chat', 'ToggleChatButton');

  return (
    <FocusableIconButton
      aria-label={label}
      focusIndex={focusIndex}
      icon={SVGAsset.TheaterExit}
      onClick={onClick}
    />
  );
};

ToggleChatButton.displayName = 'ToggleChatButton';
