import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { FocusableIconButton } from '../../../../../common';
import { ToggleChatButton } from '.';

describe(ToggleChatButton, () => {
  const setup = createShallowWrapperFactory(ToggleChatButton, () => ({
    chatVisible: true,
    focusIndex: 0,
    onClick: jest.fn(),
  }));

  it('provides the right hint', () => {
    const { wrapper } = setup();
    expect(wrapper.find(FocusableIconButton)).toHaveProp({
      'aria-label': 'Hide chat',
    });

    wrapper.setProps({ chatVisible: false });
    expect(wrapper.find(FocusableIconButton)).toHaveProp({
      'aria-label': 'Show chat',
    });
  });

  it('invokes the callback when clicked', () => {
    const { props, wrapper } = setup();
    expect(props.onClick).not.toHaveBeenCalled();

    wrapper.find(FocusableIconButton).simulate('click');
    expect(props.onClick).toHaveBeenCalledTimes(1);
  });
});
