import { datatype, internet } from 'faker';
import { act } from 'react-dom/test-utils';
// @ts-expect-error: no types for s-c test utils yets
import { enzymeFind } from 'styled-components/test-utils';
import {
  createMountWrapperFactory,
  createShallowWrapperFactory,
} from 'tachyon-test-utils';
import { HorizontalNav } from 'tachyon-tv-nav';
import { useUpdateVideoPlaybackPosition } from '../../../../hooks';
import { Chat } from '../../../Chat';
import { BottomControls } from './BottomControls';
import {
  ChannelPlayingUIBase,
  PLAYER_WIDTH_WITH_CHAT_VW,
  ScChatAside,
  ScPlayerSection,
} from '.';

jest.mock('../../../Chat/chat.worker', () => jest.fn());

jest.mock('./BottomControls', () => ({
  BottomControls: () => <div />,
}));

jest.mock('../../../Chat', () => ({
  Chat: () => <div />,
}));

jest.mock('../../../player', () => ({
  StreamPlayer: () => <div />,
}));

jest.mock('../../../../hooks', () => ({
  useUpdateVideoPlaybackPosition: jest.fn(),
}));
const mockUseUpdateVideoPlaybackPosition =
  useUpdateVideoPlaybackPosition as jest.Mock;

describe(ChannelPlayingUIBase, () => {
  const setup = createMountWrapperFactory(ChannelPlayingUIBase, () => ({
    channel: {
      ' $fragmentRefs': {
        BottomControls_channel: true,
        StreamPlayer_channel: true,
      },
      ' $refType': 'ChannelPlayingUI_channel',
      displayName: internet.userName(),
      id: datatype.uuid(),
      login: internet.userName(),
      roles: null,
      stream: {
        archiveVideo: {
          id: datatype.uuid(),
        },
        playbackAccessToken: {
          signature: datatype.uuid(),
          value: datatype.uuid(),
        },
      },
    },
    currentUser: null,
    focusIndex: 0,
    onPlaybackEnd: jest.fn(),
    streamToken: {
      ' $fragmentRefs': { StreamPlayer_token: true },
    },
  }));

  beforeEach(() => {
    jest.resetAllMocks();
  });

  describe('chat', () => {
    it('toggles and updates styles', () => {
      const { wrapper } = setup();

      expect(wrapper.find(HorizontalNav)).toHaveProp({ elementCount: 2 });
      expect(wrapper.find(Chat)).toExist();
      expect(wrapper.find(ScPlayerSection)).toHaveProp({ $displayChat: true });
      expect(wrapper.find(ScChatAside)).toHaveProp({ $displayChat: true });

      act(() => {
        wrapper.find(BottomControls).prop('onChatToggle')();
      });

      wrapper.update();
      expect(wrapper.find(HorizontalNav)).toHaveProp({ elementCount: 1 });
      expect(wrapper.find(ScPlayerSection)).toHaveProp({
        $displayChat: false,
      });
      expect(wrapper.find(ScChatAside)).toHaveProp({ $displayChat: false });
    });
  });

  it('calls the hook to set up video playback position update mutations', () => {
    const { props } = setup({
      currentUser: {
        id: internet.userName(),
      },
    });
    expect(mockUseUpdateVideoPlaybackPosition).toHaveBeenCalledWith({
      userID: props.currentUser!.id,
      videoID: props.channel.stream!.archiveVideo!.id,
      videoType: 'LIVE',
    });
  });
});

describe('ScPlayerSection', () => {
  const setup = createShallowWrapperFactory(ScPlayerSection, () => ({
    $displayChat: false,
  }));

  it('sets the expected width when chat is displayed', () => {
    const { wrapper } = setup({ $displayChat: true });
    expect(wrapper).toHaveStyleRule('width', `${PLAYER_WIDTH_WITH_CHAT_VW}vw`);
  });

  it('sets the expected width when chat is hidden', () => {
    const { wrapper } = setup({ $displayChat: false });
    expect(wrapper).toHaveStyleRule('width', '100vw');
  });
});

describe('ScChatAside', () => {
  const setup = createShallowWrapperFactory(ScChatAside, () => ({
    $displayChat: false,
  }));

  it('sets a transform when chat is displayed', () => {
    const { wrapper } = setup({ $displayChat: true });
    expect(wrapper).toHaveStyleRule('transform');
  });

  it('omits the transform when chat is hidden', () => {
    const { wrapper } = setup({ $displayChat: false });
    expect(enzymeFind(wrapper, ScChatAside)).not.toHaveStyleRule('transform');
  });
});
