/* tslint:disable */
/* eslint-disable */
// @ts-nocheck

import { ConcreteRequest } from "relay-runtime";
import { FragmentRefs } from "relay-runtime";
export type Channel_QueryVariables = {
    login: string;
    platform: string;
    playerType: string;
    skipPlayToken: boolean;
};
export type Channel_QueryResponse = {
    readonly channel: {
        readonly id: string;
        readonly login: string;
        readonly displayName: string;
        readonly broadcastSettings: {
            readonly isMature: boolean;
        } | null;
        readonly stream: {
            readonly restrictionType: string | null;
            readonly self: {
                readonly canWatch: boolean;
            } | null;
            readonly id: string;
            readonly game: {
                readonly name: string;
            } | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"ChannelPlayingUI_channel">;
    } | null;
    readonly currentUser: {
        readonly id: string;
        readonly login: string;
        readonly roles: {
            readonly isStaff: boolean | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"ChannelPlayingUI_currentUser">;
    } | null;
    readonly " $fragmentRefs": FragmentRefs<"StreamPlayer_token">;
};
export type Channel_Query = {
    readonly response: Channel_QueryResponse;
    readonly variables: Channel_QueryVariables;
};



/*
query Channel_Query(
  $login: String!
  $platform: String!
  $playerType: String!
  $skipPlayToken: Boolean!
) {
  channel: user(login: $login) {
    ...ChannelPlayingUI_channel
    id
    login
    displayName
    broadcastSettings {
      isMature
      id
    }
    stream {
      restrictionType
      self {
        canWatch
      }
      id
      game {
        name
        id
      }
    }
  }
  currentUser {
    ...ChannelPlayingUI_currentUser
    id
    login
    roles {
      isStaff
    }
  }
  ...StreamPlayer_token
}

fragment BottomControls_channel on User {
  id
  self {
    follower {
      followedAt
    }
  }
  ...FocusableFollowButton_channel
  ...PlaybackInfo_channel
  broadcastSettings {
    title
    game {
      displayName
      id
    }
    id
  }
  login
  stream {
    createdAt
    id
    viewersCount
  }
}

fragment ChannelPlayingUI_channel on User {
  stream {
    archiveVideo {
      id
    }
    id
  }
  id
  login
  displayName
  roles {
    isAffiliate
    isPartner
  }
  ...StreamPlayer_channel
  ...BottomControls_channel
}

fragment ChannelPlayingUI_currentUser on User {
  ...StreamPlayer_currentUser
  id
  login
  roles {
    isStaff
  }
}

fragment FocusableFollowButton_channel on User {
  login
  id
  self {
    follower {
      followedAt
    }
  }
}

fragment PlaybackInfo_channel on User {
  displayName
  hosting {
    id
  }
  login
  profileImageURL(width: 70)
  primaryColorHex
}

fragment StreamPlayer_channel on User {
  id
  login
  roles {
    isPartner
  }
  self {
    subscriptionBenefit {
      id
    }
  }
  stream {
    id
    game {
      name
      id
    }
    previewImageURL
  }
}

fragment StreamPlayer_currentUser on User {
  hasTurbo
  id
}

fragment StreamPlayer_token on Query {
  user(login: $login) {
    login
    stream @skip(if: $skipPlayToken) {
      playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {
        signature
        value
      }
      id
    }
    id
  }
}
*/

const node: ConcreteRequest = (function(){
var v0 = [
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "login"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "platform"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "playerType"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "skipPlayToken"
  }
],
v1 = [
  {
    "kind": "Variable",
    "name": "login",
    "variableName": "login"
  }
],
v2 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "id",
  "storageKey": null
},
v3 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "login",
  "storageKey": null
},
v4 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "displayName",
  "storageKey": null
},
v5 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "isMature",
  "storageKey": null
},
v6 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "restrictionType",
  "storageKey": null
},
v7 = {
  "alias": null,
  "args": null,
  "concreteType": "StreamSelfConnection",
  "kind": "LinkedField",
  "name": "self",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "canWatch",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v8 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "name",
  "storageKey": null
},
v9 = {
  "alias": null,
  "args": null,
  "concreteType": "UserRoles",
  "kind": "LinkedField",
  "name": "roles",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "isStaff",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v10 = [
  (v2/*: any*/)
];
return {
  "fragment": {
    "argumentDefinitions": (v0/*: any*/),
    "kind": "Fragment",
    "metadata": null,
    "name": "Channel_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v2/*: any*/),
          (v3/*: any*/),
          (v4/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "BroadcastSettings",
            "kind": "LinkedField",
            "name": "broadcastSettings",
            "plural": false,
            "selections": [
              (v5/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": [
              (v6/*: any*/),
              (v7/*: any*/),
              (v2/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Game",
                "kind": "LinkedField",
                "name": "game",
                "plural": false,
                "selections": [
                  (v8/*: any*/)
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "ChannelPlayingUI_channel"
          }
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          (v2/*: any*/),
          (v3/*: any*/),
          (v9/*: any*/),
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "ChannelPlayingUI_currentUser"
          }
        ],
        "storageKey": null
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "StreamPlayer_token"
      }
    ],
    "type": "Query",
    "abstractKey": null
  },
  "kind": "Request",
  "operation": {
    "argumentDefinitions": (v0/*: any*/),
    "kind": "Operation",
    "name": "Channel_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "Video",
                "kind": "LinkedField",
                "name": "archiveVideo",
                "plural": false,
                "selections": (v10/*: any*/),
                "storageKey": null
              },
              (v2/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Game",
                "kind": "LinkedField",
                "name": "game",
                "plural": false,
                "selections": [
                  (v8/*: any*/),
                  (v2/*: any*/)
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "previewImageURL",
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "createdAt",
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "viewersCount",
                "storageKey": null
              },
              (v6/*: any*/),
              (v7/*: any*/)
            ],
            "storageKey": null
          },
          (v2/*: any*/),
          (v3/*: any*/),
          (v4/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "UserRoles",
            "kind": "LinkedField",
            "name": "roles",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "isAffiliate",
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "isPartner",
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "UserSelfConnection",
            "kind": "LinkedField",
            "name": "self",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "SubscriptionBenefit",
                "kind": "LinkedField",
                "name": "subscriptionBenefit",
                "plural": false,
                "selections": (v10/*: any*/),
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "FollowerEdge",
                "kind": "LinkedField",
                "name": "follower",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "followedAt",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "hosting",
            "plural": false,
            "selections": (v10/*: any*/),
            "storageKey": null
          },
          {
            "alias": null,
            "args": [
              {
                "kind": "Literal",
                "name": "width",
                "value": 70
              }
            ],
            "kind": "ScalarField",
            "name": "profileImageURL",
            "storageKey": "profileImageURL(width:70)"
          },
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "primaryColorHex",
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "BroadcastSettings",
            "kind": "LinkedField",
            "name": "broadcastSettings",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "title",
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "Game",
                "kind": "LinkedField",
                "name": "game",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  (v2/*: any*/)
                ],
                "storageKey": null
              },
              (v2/*: any*/),
              (v5/*: any*/)
            ],
            "storageKey": null
          }
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "hasTurbo",
            "storageKey": null
          },
          (v2/*: any*/),
          (v3/*: any*/),
          (v9/*: any*/)
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v3/*: any*/),
          (v2/*: any*/),
          {
            "condition": "skipPlayToken",
            "kind": "Condition",
            "passingValue": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": [
                      {
                        "fields": [
                          {
                            "kind": "Variable",
                            "name": "platform",
                            "variableName": "platform"
                          },
                          {
                            "kind": "Variable",
                            "name": "playerType",
                            "variableName": "playerType"
                          }
                        ],
                        "kind": "ObjectValue",
                        "name": "params"
                      }
                    ],
                    "concreteType": "PlaybackAccessToken",
                    "kind": "LinkedField",
                    "name": "playbackAccessToken",
                    "plural": false,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "signature",
                        "storageKey": null
                      },
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "value",
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  },
                  (v2/*: any*/)
                ],
                "storageKey": null
              }
            ]
          }
        ],
        "storageKey": null
      }
    ]
  },
  "params": {
    "cacheID": "cc5f29012039546e02d8427669ce9fb4",
    "id": null,
    "metadata": {},
    "name": "Channel_Query",
    "operationKind": "query",
    "text": "query Channel_Query(\n  $login: String!\n  $platform: String!\n  $playerType: String!\n  $skipPlayToken: Boolean!\n) {\n  channel: user(login: $login) {\n    ...ChannelPlayingUI_channel\n    id\n    login\n    displayName\n    broadcastSettings {\n      isMature\n      id\n    }\n    stream {\n      restrictionType\n      self {\n        canWatch\n      }\n      id\n      game {\n        name\n        id\n      }\n    }\n  }\n  currentUser {\n    ...ChannelPlayingUI_currentUser\n    id\n    login\n    roles {\n      isStaff\n    }\n  }\n  ...StreamPlayer_token\n}\n\nfragment BottomControls_channel on User {\n  id\n  self {\n    follower {\n      followedAt\n    }\n  }\n  ...FocusableFollowButton_channel\n  ...PlaybackInfo_channel\n  broadcastSettings {\n    title\n    game {\n      displayName\n      id\n    }\n    id\n  }\n  login\n  stream {\n    createdAt\n    id\n    viewersCount\n  }\n}\n\nfragment ChannelPlayingUI_channel on User {\n  stream {\n    archiveVideo {\n      id\n    }\n    id\n  }\n  id\n  login\n  displayName\n  roles {\n    isAffiliate\n    isPartner\n  }\n  ...StreamPlayer_channel\n  ...BottomControls_channel\n}\n\nfragment ChannelPlayingUI_currentUser on User {\n  ...StreamPlayer_currentUser\n  id\n  login\n  roles {\n    isStaff\n  }\n}\n\nfragment FocusableFollowButton_channel on User {\n  login\n  id\n  self {\n    follower {\n      followedAt\n    }\n  }\n}\n\nfragment PlaybackInfo_channel on User {\n  displayName\n  hosting {\n    id\n  }\n  login\n  profileImageURL(width: 70)\n  primaryColorHex\n}\n\nfragment StreamPlayer_channel on User {\n  id\n  login\n  roles {\n    isPartner\n  }\n  self {\n    subscriptionBenefit {\n      id\n    }\n  }\n  stream {\n    id\n    game {\n      name\n      id\n    }\n    previewImageURL\n  }\n}\n\nfragment StreamPlayer_currentUser on User {\n  hasTurbo\n  id\n}\n\nfragment StreamPlayer_token on Query {\n  user(login: $login) {\n    login\n    stream @skip(if: $skipPlayToken) {\n      playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {\n        signature\n        value\n      }\n      id\n    }\n    id\n  }\n}\n"
  }
};
})();
(node as any).hash = '1bf89d60f300b518af1f6731d447779c';
export default node;
