import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  AlignItems,
  CoreText,
  Display,
  FlexDirection,
  Layout,
  TextType,
  Title,
  TitleSize,
} from 'twitch-core-ui';

// istanbul ignore next: trivial
export const NoVideoShelvesMessage: FC = () => {
  const { formatMessage } = useIntl();

  return (
    <Layout
      alignItems={AlignItems.Center}
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      fullWidth
      padding={{ top: 5 }}
    >
      <Title size={TitleSize.Default}>
        {formatMessage('Nothing to see here…', 'NoVideoShelvesMessage')}
      </Title>
      <CoreText type={TextType.P}>
        {formatMessage('This creator has no content.', 'NoVideoShelvesMessage')}
      </CoreText>
    </Layout>
  );
};

NoVideoShelvesMessage.displayName = 'NoVideoShelvesMessage';
