import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../../../routing';
import { FocusableTextButton } from '../../../../../common';

type WatchLatestVodButtonProps = {
  focusIndex: number;
  videoId: string;
};

// istanbul ignore next: trivial
export const WatchLatestVodButton: FC<WatchLatestVodButtonProps> = ({
  focusIndex,
  videoId,
}) => {
  const { formatMessage } = useIntl();

  return (
    <FocusableTextButton
      focusIndex={focusIndex}
      icon={SVGAsset.Play}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        route: RouteName.Vod,
        routeParams: {
          id: videoId,
        },
      })}
      withUnfocusBackground
    >
      {formatMessage('Watch Latest Video', 'WatchLatestVodButton')}
    </FocusableTextButton>
  );
};
WatchLatestVodButton.displayName = 'WatchLatestVodButton';
