import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { StreamType } from 'tachyon-more-ui';
import { SVGAsset } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../../../routing';
import { FocusableTextButton } from '../../../../../common';

type WatchStreamButtonProps = {
  focusIndex: number;
  login: string;
  type: StreamType;
};

export const WatchStreamButton: FC<WatchStreamButtonProps> = ({
  focusIndex,
  login,
  type,
}) => {
  const { formatMessage } = useIntl();

  let text: string;
  switch (type) {
    case StreamType.Hosting:
      text = formatMessage('Watch Hosted Channel', 'ProfileBanner');
      break;
    case StreamType.Rerun:
      text = formatMessage('Watch Rerun', 'ProfileBanner');
      break;
    case StreamType.Live:
    case StreamType.Premiere:
      text = formatMessage('Watch Live', 'ProfileBanner');
      break;
    default:
      const exhaust: never = type;
      text = exhaust;
      break;
  }

  return (
    <FocusableTextButton
      focusIndex={focusIndex}
      icon={type === StreamType.Hosting ? SVGAsset.Externallink : SVGAsset.Play}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        route: RouteName.Channel,
        routeParams: { login },
      })}
      withUnfocusBackground
    >
      {text}
    </FocusableTextButton>
  );
};
WatchStreamButton.displayName = 'WatchStreamButton';
