import { lorem } from 'faker';
import { StreamType } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SVGAsset } from 'twitch-core-ui';
import { FocusableTextButton } from '../../../../../common';
import { WatchStreamButton } from '.';

jest.mock('tachyon-tv-nav', () => ({
  ...jest.requireActual('tachyon-tv-nav'),
  useFocus: jest.fn(() => ({ focused: true })),
}));

describe(WatchStreamButton, () => {
  const setup = createShallowWrapperFactory(WatchStreamButton, () => ({
    focusIndex: 0,
    login: lorem.word(),
    type: StreamType.Live,
  }));

  describe('live', () => {
    it('contains the live text and play icon', () => {
      const { wrapper } = setup({
        type: StreamType.Live,
      });
      expect(wrapper.childAt(0).text()).toEqual('Watch Live');
      expect(wrapper.prop('icon')).toEqual(SVGAsset.Play);
    });
  });

  describe('premiere', () => {
    it('contains the live text and play icon', () => {
      const { wrapper } = setup({
        type: StreamType.Premiere,
      });
      expect(wrapper.childAt(0).text()).toEqual('Watch Live');
      expect(wrapper.prop('icon')).toEqual(SVGAsset.Play);
    });
  });

  describe('rerun', () => {
    it('contains the rerun text and play icon', () => {
      const { wrapper } = setup({
        type: StreamType.Rerun,
      });
      expect(wrapper.childAt(0).text()).toEqual('Watch Rerun');
      expect(wrapper.prop('icon')).toEqual(SVGAsset.Play);
    });
  });

  describe('hosting', () => {
    it('contains the hosting text and hosting icon', () => {
      const { wrapper } = setup({
        type: StreamType.Hosting,
      });
      expect(wrapper.find(FocusableTextButton).childAt(0).text()).toEqual(
        `Watch Hosted Channel`,
      );
      expect(wrapper.prop('icon')).toEqual(SVGAsset.Externallink);
    });
  });
});
