import { internet } from 'faker';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory, randomId } from 'tachyon-test-utils';
import { BannerChannelStatusBase } from '.';

jest.mock('tachyon-tv-nav', () => ({
  ...jest.requireActual('tachyon-tv-nav'),
  useFocus: jest.fn(() => ({ focused: true })),
}));

const mockLiveChannel = (type?: string) =>
  ({
    ' $refType': 'BannerChannelStatus_channel',
    displayName: internet.userName(),
    hosting: null,
    id: validId(randomId()),
    login: internet.userName(),
    stream: {
      id: validId(randomId()),
      type: type ?? 'live',
    },
  } as const);

const mockHostingChannel = () =>
  ({
    ' $refType': 'BannerChannelStatus_channel',
    displayName: internet.userName(),
    hosting: {
      displayName: internet.userName(),
      id: validId(randomId()),
      login: internet.userName(),
      stream: {
        id: validId(randomId()),
        type: 'hosting',
      },
    },
    id: validId(randomId()),
    login: internet.userName(),
    stream: null,
  } as const);

const mockOfflineChannel = () =>
  ({
    ' $refType': 'BannerChannelStatus_channel',
    displayName: internet.userName(),
    hosting: null,
    id: validId(randomId()),
    login: internet.userName(),
    stream: null,
  } as const);

describe(BannerChannelStatusBase, () => {
  const setup = createShallowWrapperFactory(BannerChannelStatusBase, () => ({
    channel: mockOfflineChannel(),
    focusIndex: 0,
  }));

  describe('live', () => {
    it('renders the correct button text', () => {
      const { wrapper } = setup({
        channel: mockLiveChannel('live'),
      });
      expect(wrapper).toHaveText('LIVE NOW');
    });
  });

  describe('hosting', () => {
    it('contains hosting/follow/report buttons in the horizontal nav when expanded', () => {
      const channel = mockHostingChannel();
      const { wrapper } = setup({
        channel,
      });
      expect(wrapper).toHaveText(`HOSTING ${channel.hosting.displayName}`);
    });
  });

  describe('rerun', () => {
    it('contains watch/follow/report buttons in the horizontal nav when expanded', () => {
      const { wrapper } = setup({
        channel: mockLiveChannel('rerun'),
      });
      expect(wrapper).toHaveText('RERUN');
    });
  });

  describe('offline', () => {
    it('contains follow/report buttons in the horizontal nav when expanded', () => {
      const { wrapper } = setup({
        channel: mockOfflineChannel(),
      });
      expect(wrapper).toHaveText('OFFLINE');
    });
  });
});
