import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { formatFollowers, formatTotalViewCount } from 'tachyon-more-ui';
import { Color, CoreText, FontSize } from 'twitch-core-ui';

type BannerStatsLineProps = {
  followers?: number | null;
  views?: number | null;
};

export const BannerStatsLine: FC<BannerStatsLineProps> = ({
  followers,
  views,
}) => {
  const intl = useIntl();
  const { formatMessage, formatNumberShort } = intl;

  const formattedFollowers = followers && formatFollowers(intl, followers);
  const formattedViews =
    views &&
    formatTotalViewCount(
      formatMessage,
      views,
      formatNumberShort(views, {
        maximumSignificantDigits: 2,
      }),
    );

  let text: string | undefined;
  if (formattedFollowers && formattedViews) {
    text = `${formattedFollowers}  |  ${formattedViews}`;
  } else if (formattedFollowers) {
    text = formattedFollowers;
  } else if (formattedViews) {
    text = formattedViews;
  }

  return text ? (
    <CoreText color={Color.Alt2} fontSize={FontSize.Size7}>
      {text}
    </CoreText>
  ) : null;
};
BannerStatsLine.displayName = 'BannerStatsLine';
