import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { BannerStatsLine } from '.';

describe('BannerStatsLine', () => {
  const setup = createShallowWrapperFactory(BannerStatsLine, () => ({
    followers: 2,
    views: 3,
  }));

  it('contains followers and views when both are valid numbers', () => {
    const { wrapper } = setup();
    expect(wrapper.find(CoreText).childAt(0).text()).toContain('follower');
    expect(wrapper.find(CoreText).childAt(0).text()).toContain('view');
  });

  it('contains followers only if views are falsy', () => {
    const { wrapper } = setup({ views: null });
    expect(wrapper.find(CoreText).childAt(0).text()).toContain('follower');
    expect(wrapper.find(CoreText).childAt(0).text()).not.toContain('view');
  });

  it('contains views only if followers are falsy', () => {
    const { wrapper } = setup({ followers: null });
    expect(wrapper.find(CoreText).childAt(0).text()).not.toContain('follower');
    expect(wrapper.find(CoreText).childAt(0).text()).toContain('view');
  });

  it('is null if followers and viewers are falsy', () => {
    const { wrapper } = setup({ followers: null, views: null });
    expect(wrapper.find(CoreText)).not.toExist();
  });
});
